/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import javax.annotation.Nullable;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.fluids.FluidStack;

public class RenderHelper {
    public static float rot = 0.0f;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static final RenderSettings DEFAULT_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(128).build();

    public static void renderEntity(PoseStack matrixStack, Entity entity, int xPos, int yPos) {
        float f1 = 10.0f;
        RenderHelper.renderEntity(matrixStack, entity, xPos, yPos, f1);
    }

    public static void adjustTransformToDirection(PoseStack matrixStack, Direction facing) {
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        switch (facing) {
            case DOWN: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case UP: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                break;
            }
            case NORTH: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                break;
            }
            case EAST: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
    }

    public static void renderNorthSouthQuad(VertexConsumer builder, Matrix4f matrix, TextureAtlasSprite sprite, ModelBuilder.FaceRotation rotation, float offset) {
        switch (rotation) {
            case ZERO: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                break;
            }
            case CLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                break;
            }
            case UPSIDE_DOWN: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
            }
        }
    }

    public static void renderEntity(PoseStack matrixStack, Entity entity, int xPos, int yPos, float scale) {
        matrixStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(xPos + 8), (double)(yPos + 16), 50.0);
        matrixStack.m_85841_(-scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(135.0f));
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(135.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rot));
        entity.m_146926_(0.0f);
        matrixStack.m_85837_(0.0, (double)((float)entity.m_6049_()), 0.0);
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i1 = 240;
        int k1 = 240;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84507_();
        matrixStack.m_85849_();
    }

    public static boolean renderObject(PoseStack matrixStack, int x, int y, Object itm, boolean highlight) {
        if (itm instanceof Entity) {
            RenderHelper.renderEntity(matrixStack, (Entity)itm, x, y);
            return true;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        return RenderHelper.renderObject(matrixStack, itemRenderer, x, y, itm, highlight, 100.0f);
    }

    public static boolean renderObject(PoseStack matrixStack, ItemRenderer itemRender, int x, int y, Object itm, boolean highlight, float lvl) {
        itemRender.f_115093_ = lvl;
        if (itm == null) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, ItemStack.f_41583_, x, y, "", highlight);
        }
        if (itm instanceof Item) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, new ItemStack((ItemLike)((Item)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof Block) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, new ItemStack((ItemLike)((Block)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof ItemStack) {
            return RenderHelper.renderItemStackWithCount(matrixStack, itemRender, (ItemStack)itm, x, y, highlight);
        }
        if (itm instanceof FluidStack) {
            return RenderHelper.renderFluidStack((FluidStack)itm, x, y, highlight);
        }
        if (itm instanceof TextureAtlasSprite) {
            return RenderHelper.renderIcon(matrixStack, itemRender, (TextureAtlasSprite)itm, x, y, highlight);
        }
        return RenderHelper.renderItemStack(matrixStack, itemRender, ItemStack.f_41583_, x, y, "", highlight);
    }

    public static boolean renderIcon(PoseStack matrixStack, ItemRenderer itemRender, TextureAtlasSprite itm, int xo, int yo, boolean highlight) {
        return true;
    }

    public static boolean renderFluidStack(FluidStack fluidStack, int x, int y, boolean highlight) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        ResourceLocation fluidStill = fluid.getAttributes().getStillTexture();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        }
        if (fluidStillSprite == null) {
            return false;
        }
        int fluidColor = fluid.getAttributes().getColor(fluidStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderHelper.setGLColorFromInt(fluidColor);
        RenderHelper.drawFluidTexture(x, y, fluidStillSprite, 100.0);
        return true;
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexBuffer.m_5483_(xCoord, yCoord + 16.0, zLevel).m_7421_(uMin, vMax).m_5752_();
        vertexBuffer.m_5483_(xCoord + 16.0, yCoord + 16.0, zLevel).m_7421_(uMax, vMax).m_5752_();
        vertexBuffer.m_5483_(xCoord + 16.0, yCoord, zLevel).m_7421_(uMax, vMin).m_5752_();
        vertexBuffer.m_5483_(xCoord, yCoord, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static boolean renderItemStackWithCount(PoseStack matrixStack, ItemRenderer itemRender, ItemStack itm, int xo, int yo, boolean highlight) {
        int size = itm.m_41613_();
        Object amount = size <= 1 ? "" : (size < 100000 ? String.valueOf(size) : (size < 1000000 ? String.valueOf(size / 1000) + "k" : (size < 1000000000 ? String.valueOf(size / 1000000) + "m" : String.valueOf(size / 1000000000) + "g")));
        return RenderHelper.renderItemStack(matrixStack, itemRender, itm, xo, yo, (String)amount, highlight);
    }

    public static boolean renderItemStack(PoseStack matrixStack, ItemRenderer itemRender, ItemStack itm, int x, int y, String txt, boolean highlight) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = false;
        if (highlight) {
            RenderHelper.drawVerticalGradientRect(x, y, x + 16, y + 16, -2130706433, -1);
        }
        if (!itm.m_41619_() && itm.m_41720_() != null) {
            rc = true;
            matrixStack.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            itemRender.m_115203_(itm, x, y);
            RenderHelper.renderGuiItemDecorations(itemRender, Minecraft.m_91087_().f_91062_, itm, x, y, txt, txt.length() - 2);
            matrixStack.m_85849_();
        }
        return rc;
    }

    private static void renderGuiItemDecorations(ItemRenderer itemRender, Font font, ItemStack stack, int x, int y, @Nullable String text, int scaled) {
        if (!stack.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            PoseStack posestack = new PoseStack();
            if (stack.m_41613_() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                posestack.m_85837_(0.0, 0.0, (double)(itemRender.f_115093_ + 200.0f));
                MultiBufferSource.BufferSource source = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                if (scaled >= 2) {
                    posestack.m_85836_();
                    posestack.m_85841_(0.5f, 0.5f, 0.5f);
                    font.m_92811_(s, (float)((x + 19 - 2) * 2 - 1 - font.m_92895_(s)), (float)(y * 2 + 24), 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                    posestack.m_85849_();
                } else if (scaled == 1) {
                    posestack.m_85836_();
                    posestack.m_85841_(0.75f, 0.75f, 0.75f);
                    font.m_92811_(s, (float)(x - 2) * 1.34f + 24.0f - (float)font.m_92895_(s), (float)y * 1.34f + 14.0f, 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                    posestack.m_85849_();
                } else {
                    font.m_92811_(s, (float)(x + 19 - 2 - font.m_92895_(s)), (float)(y + 6 + 3), 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                }
                source.m_109911_();
            }
            if (stack.m_150947_()) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69461_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                int i = stack.m_150948_();
                int j = stack.m_150949_();
                RenderHelper.fillRect(bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.fillRect(bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
            float f2 = f = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f > 0.0f) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                Tesselator tesselator1 = Tesselator.m_85913_();
                BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
                RenderHelper.fillRect(bufferbuilder1, x, y + Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
        }
    }

    private static void fillRect(BufferBuilder pRenderer, int pX, int pY, int pWidth, int pHeight, int pRed, int pGreen, int pBlue, int pAlpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        pRenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        pRenderer.m_5483_((double)(pX + 0), (double)(pY + 0), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + 0), (double)(pY + pHeight), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + pWidth), (double)(pY + pHeight), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + pWidth), (double)(pY + 0), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)pRenderer);
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_5483_((double)(x + 0), (double)(y + 0), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + 0), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + 0), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x2, (double)y1, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x1, (double)y1, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x1, (double)y2, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        buffer.m_5483_((double)x2, (double)y2, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawHorizontalGradientRect(PoseStack matrixStack, int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x1, (double)y1, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x1, (double)y2, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x2, (double)y2, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        buffer.m_5483_((double)x2, (double)y1, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawHorizontalGradientRect(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int color1, int color2, int lightmap) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(positionMatrix, (float)x1, (float)y1, zLevel).m_85950_(f1, f2, f3, f).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x1, (float)y2, zLevel).m_85950_(f1, f2, f3, f).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y2, zLevel).m_85950_(f5, f6, f7, f4).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y1, zLevel).m_85950_(f5, f6, f7, f4).m_85969_(lightmap).m_5752_();
    }

    public static void drawHorizontalLine(PoseStack matrixStack, int x1, int y1, int x2, int color) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(PoseStack matrixStack, int x1, int y1, int y2, int color) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawLeftTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawVerticalLine(matrixStack, x, y, y, color);
        RenderHelper.drawVerticalLine(matrixStack, x + 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(matrixStack, x + 2, y - 2, y + 2, color);
    }

    public static void drawRightTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawVerticalLine(matrixStack, x, y, y, color);
        RenderHelper.drawVerticalLine(matrixStack, x - 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(matrixStack, x - 2, y - 2, y + 2, color);
    }

    public static void drawUpTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(matrixStack, x, y, x, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 1, y + 1, x + 1, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 2, y + 2, x + 2, color);
    }

    public static void drawDownTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(matrixStack, x, y, x, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 1, y - 1, x + 1, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 2, y - 2, x + 2, color);
    }

    public static void drawColorLogic(int x, int y, int width, int height, int red, int green, int blue, GlStateManager.LogicOp colorLogic) {
        GlStateManager.m_84110_();
        GlStateManager.m_84107_();
        GlStateManager.m_84532_((int)colorLogic.f_84715_);
        RenderHelper.draw(Tesselator.m_85913_().m_85915_(), x, y, width, height, red, green, blue, 255);
        GlStateManager.m_84108_();
        GlStateManager.m_84109_();
    }

    public static void drawThickButtonBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 2), (int)(y1 + 2), (int)(x2 - 2), (int)(y2 - 2), (int)average);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 1, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 2, y1 + 2, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 2, y1 + 3, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 3, y2 - 3, x2 - 2, dark);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 2, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 2, y2 - 2, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 3, y1 + 3, y2 - 3, dark);
    }

    public static void drawThinButtonBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)average);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawThinButtonBoxGradient(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawFlatButtonBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(matrixStack, x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBox(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int bright, int average, int dark, int lightmap) {
        RenderHelper.drawBeveledBox(matrixStack, buffer, x1, y1, x2, y2, bright, dark, average, lightmap);
    }

    public static void drawFlatButtonBoxGradient(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, bright);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, dark);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, dark);
    }

    public static void drawBeveledBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, botrightcolor);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, botrightcolor);
    }

    public static void drawBeveledBox(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor, int lightmap) {
        if (fillcolor != -1) {
            RenderHelper.fill(matrixStack, buffer, x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor, lightmap);
        }
        RenderHelper.fill(matrixStack, buffer, x1, y1, x2 - 1, y1 + 1, topleftcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x1, y1, x1 + 1, y2 - 1, topleftcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x2 - 1, y1, x2 - 1 + 1, y2 - 1, botrightcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x1, y2 - 1, x2, y2 - 1 + 1, botrightcolor, lightmap);
    }

    public static void drawThickBeveledBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawFlatBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int border, int fill) {
        if (fill != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fill);
        }
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, border);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, border);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, border);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, border);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)(x + 0), (double)(y + height), (double)zLevel).m_7421_((float)(u + 0) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + 0), (double)zLevel).m_7421_((float)(u + width) * f, (float)(v + 0) * f1).m_5752_();
        buffer.m_5483_((double)(x + 0), (double)(y + 0), (double)zLevel).m_7421_((float)(u + 0) * f, (float)(v + 0) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int totw, int toth) {
        float f = 1.0f / (float)totw;
        float f1 = 1.0f / (float)toth;
        double zLevel = 50.0;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexbuffer.m_5483_((double)(x + 0), (double)(y + height), zLevel).m_7421_((float)(textureX + 0) * f, (float)(textureY + height) * f1).m_5752_();
        vertexbuffer.m_5483_((double)(x + width), (double)(y + height), zLevel).m_7421_((float)(textureX + width) * f, (float)(textureY + height) * f1).m_5752_();
        vertexbuffer.m_5483_((double)(x + width), (double)(y + 0), zLevel).m_7421_((float)(textureX + width) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexbuffer.m_5483_((double)(x + 0), (double)(y + 0), zLevel).m_7421_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTexturedModalRect(Matrix4f positionMatrix, VertexConsumer builder, int x, int y, int textureX, int textureY, int width, int height, int totw, int toth, float parentU, float parentV) {
        float f = 1.0f / (float)totw;
        float f1 = 1.0f / (float)toth;
        float zLevel = 50.0f;
        builder.m_85982_(positionMatrix, (float)(x + 0), (float)(y + height), zLevel).m_7421_(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + height) * f1).m_5752_();
        builder.m_85982_(positionMatrix, (float)(x + width), (float)(y + height), zLevel).m_7421_(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + height) * f1).m_5752_();
        builder.m_85982_(positionMatrix, (float)(x + width), (float)(y + 0), zLevel).m_7421_(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + 0) * f1).m_5752_();
        builder.m_85982_(positionMatrix, (float)(x + 0), (float)(y + 0), zLevel).m_7421_(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + 0) * f1).m_5752_();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, (float)(x + 0), (float)(y + height), zLevel).m_7421_((float)(u + 0) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)(y + 0), zLevel).m_7421_((float)(u + width) * f, (float)(v + 0) * f1).m_5752_();
        buffer.m_85982_(matrix, (float)(x + 0), (float)(y + 0), zLevel).m_7421_((float)(u + 0) * f, (float)(v + 0) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void renderSplitBillboard(PoseStack matrixStack, VertexConsumer buffer, float scale, Vec3 offset, ResourceLocation texture) {
        int b1 = 0xF00000;
        int b2 = 240;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5 + offset.f_82480_, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float um = (u0 + u1) / 2.0f;
        float vm = (v0 + v1) / 2.0f;
        buffer.m_85982_(matrix, -scale, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -scale, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        matrixStack.m_85849_();
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, MultiBufferSource buffer, float scale, ResourceLocation texture) {
        RenderHelper.renderBillboardQuadBright(matrixStack, buffer, scale, texture, DEFAULT_SETTINGS);
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, VertexConsumer builder, float scale, ResourceLocation texture, RenderSettings settings) {
        int b1 = settings.getBrightness() >> 16 & 0xFFFF;
        int b2 = settings.getBrightness() & 0xFFFF;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(matrix, -scale, -scale, 0.0f).m_6122_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, -scale, scale, 0.0f).m_6122_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, scale, scale, 0.0f).m_6122_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, scale, -scale, 0.0f).m_6122_(settings.getR(), settings.getG(), settings.getB(), settings.getA()).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        matrixStack.m_85849_();
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, MultiBufferSource buffer, float scale, ResourceLocation texture, RenderSettings settings) {
        RenderHelper.renderBillboardQuadBright(matrixStack, buffer.m_6299_(settings.getRenderType()), scale, texture, settings);
    }

    public static void rotateToPlayer(PoseStack matrixStack) {
        Quaternion rotation = Minecraft.m_91087_().f_91063_.m_109153_().m_90591_();
        matrixStack.m_85845_(rotation);
    }

    public static int renderText(PoseStack matrixStack, int x, int y, String txt) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84507_();
        GlStateManager.m_84519_();
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.f_91062_.m_92895_(txt);
        mc.f_91062_.m_92750_(matrixStack, txt, (float)x, (float)y, 0xFFFFFF);
        GlStateManager.m_84513_();
        GlStateManager.m_84525_();
        matrixStack.m_85849_();
        return width;
    }

    public static int renderText(PoseStack matrixStack, int x, int y, String txt, int color) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84507_();
        GlStateManager.m_84519_();
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.f_91062_.m_92895_(txt);
        mc.f_91062_.m_92883_(matrixStack, txt, (float)x, (float)y, color);
        GlStateManager.m_84513_();
        GlStateManager.m_84525_();
        matrixStack.m_85849_();
        return width;
    }

    public static void drawBeam(Matrix4f matrix, VertexConsumer builder, TextureAtlasSprite sprite, Vector3f S, Vector3f E, Vector3f P, float width) {
        Vector3f PS = RenderHelper.Sub(S, P);
        Vector3f SE = RenderHelper.Sub(E, S);
        Vector3f normal = RenderHelper.Cross(PS, SE);
        normal.m_122278_();
        Vector3f half = RenderHelper.Mul(normal, width);
        Vector3f p1 = RenderHelper.Add(S, half);
        Vector3f p2 = RenderHelper.Sub(S, half);
        Vector3f p3 = RenderHelper.Add(E, half);
        Vector3f p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(matrix, builder, sprite, p1, p3, p4, p2, DEFAULT_SETTINGS);
    }

    public static void drawBeam(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vector3f S, Vector3f E, Vector3f P, RenderSettings settings) {
        Vector3f PS = RenderHelper.Sub(S, P);
        Vector3f SE = RenderHelper.Sub(E, S);
        Vector3f normal = RenderHelper.Cross(PS, SE);
        normal.m_122278_();
        Vector3f half = RenderHelper.Mul(normal, settings.getWidth());
        Vector3f p1 = RenderHelper.Add(S, half);
        Vector3f p2 = RenderHelper.Sub(S, half);
        Vector3f p3 = RenderHelper.Add(E, half);
        Vector3f p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(matrix, buffer, sprite, p1, p3, p4, p2, settings);
    }

    public static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, RenderSettings settings) {
        int b1 = settings.getBrightness() >> 16 & 0xFFFF;
        int b2 = settings.getBrightness() & 0xFFFF;
        RenderHelper.vt(buffer, matrix, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), sprite.m_118409_(), sprite.m_118411_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        RenderHelper.vt(buffer, matrix, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), sprite.m_118410_(), sprite.m_118411_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        RenderHelper.vt(buffer, matrix, p3.m_122239_(), p3.m_122260_(), p3.m_122269_(), sprite.m_118410_(), sprite.m_118412_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        RenderHelper.vt(buffer, matrix, p4.m_122239_(), p4.m_122260_(), p4.m_122269_(), sprite.m_118409_(), sprite.m_118412_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
    }

    public static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, boolean opposite, RenderSettings settings) {
        int b1 = settings.getBrightness() >> 16 & 0xFFFF;
        int b2 = settings.getBrightness() & 0xFFFF;
        if (opposite) {
            RenderHelper.vt(buffer, matrix, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), sprite.m_118409_(), sprite.m_118411_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
            RenderHelper.vt(buffer, matrix, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), sprite.m_118410_(), sprite.m_118411_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
            RenderHelper.vt(buffer, matrix, p3.m_122239_(), p3.m_122260_(), p3.m_122269_(), sprite.m_118410_(), sprite.m_118412_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
            RenderHelper.vt(buffer, matrix, p4.m_122239_(), p4.m_122260_(), p4.m_122269_(), sprite.m_118409_(), sprite.m_118412_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        } else {
            RenderHelper.vt(buffer, matrix, p4.m_122239_(), p4.m_122260_(), p4.m_122269_(), sprite.m_118409_(), sprite.m_118412_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
            RenderHelper.vt(buffer, matrix, p3.m_122239_(), p3.m_122260_(), p3.m_122269_(), sprite.m_118410_(), sprite.m_118412_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
            RenderHelper.vt(buffer, matrix, p2.m_122239_(), p2.m_122260_(), p2.m_122269_(), sprite.m_118410_(), sprite.m_118411_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
            RenderHelper.vt(buffer, matrix, p1.m_122239_(), p1.m_122260_(), p1.m_122269_(), sprite.m_118409_(), sprite.m_118411_(), b1, b2, settings.getR(), settings.getG(), settings.getB(), settings.getA());
        }
    }

    public static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Direction side, boolean opposite, float offset, RenderSettings settings) {
        switch (side) {
            case DOWN: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vector3f(0.0f, offset, 1.0f), new Vector3f(1.0f, offset, 1.0f), new Vector3f(1.0f, offset, 0.0f), new Vector3f(0.0f, offset, 0.0f), opposite, settings);
                break;
            }
            case UP: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vector3f(1.0f, 1.0f - offset, 1.0f), new Vector3f(0.0f, 1.0f - offset, 1.0f), new Vector3f(0.0f, 1.0f - offset, 0.0f), new Vector3f(1.0f, 1.0f - offset, 0.0f), opposite, settings);
                break;
            }
            case NORTH: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vector3f(0.0f, 0.0f, offset), new Vector3f(1.0f, 0.0f, offset), new Vector3f(1.0f, 1.0f, offset), new Vector3f(0.0f, 1.0f, offset), opposite, settings);
                break;
            }
            case SOUTH: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vector3f(0.0f, 1.0f, 1.0f - offset), new Vector3f(1.0f, 1.0f, 1.0f - offset), new Vector3f(1.0f, 0.0f, 1.0f - offset), new Vector3f(0.0f, 0.0f, 1.0f - offset), opposite, settings);
                break;
            }
            case WEST: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vector3f(offset, 0.0f, 0.0f), new Vector3f(offset, 1.0f, 0.0f), new Vector3f(offset, 1.0f, 1.0f), new Vector3f(offset, 0.0f, 1.0f), opposite, settings);
                break;
            }
            case EAST: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vector3f(1.0f - offset, 0.0f, 1.0f), new Vector3f(1.0f - offset, 1.0f, 1.0f), new Vector3f(1.0f - offset, 1.0f, 0.0f), new Vector3f(1.0f - offset, 0.0f, 0.0f), opposite, settings);
            }
        }
    }

    public static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v) {
        renderer.m_85982_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_85969_(0xF000F0).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int lu, int lv, int r, int g, int b, int a) {
        renderer.m_85982_(matrix, x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_7120_(lu, lv).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int lu, int lv, float r, float g, float b, float a) {
        renderer.m_85982_(matrix, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_7120_(lu, lv).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void putVertex(Matrix4f matrix, IVertexConsumer builder, Position normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        Vector4f vector4f = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        vector4f.m_123607_(matrix);
        RenderHelper.putVertex(builder, normal, vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), u, v, sprite, r, g, b, a);
    }

    public static void putVertex(IVertexConsumer builder, Position normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block10: for (int e = 0; e < elements.size(); ++e) {
            switch (((VertexFormatElement)elements.get(e)).m_86048_()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z});
                    continue block10;
                }
                case COLOR: {
                    builder.put(e, new float[]{r, g, b, a});
                    continue block10;
                }
                case UV: {
                    switch (((VertexFormatElement)elements.get(e)).m_86049_()) {
                        case 0: {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(e, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(e, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(e, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.m_7096_(), (float)normal.m_7098_(), (float)normal.m_7094_()});
                    continue block10;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private static Vector3f Cross(Vector3f a, Vector3f b) {
        float x = a.m_122260_() * b.m_122269_() - a.m_122269_() * b.m_122260_();
        float y = a.m_122269_() * b.m_122239_() - a.m_122239_() * b.m_122269_();
        float z = a.m_122239_() * b.m_122260_() - a.m_122260_() * b.m_122239_();
        return new Vector3f(x, y, z);
    }

    private static Vector3f Sub(Vector3f a, Vector3f b) {
        return new Vector3f(a.m_122239_() - b.m_122239_(), a.m_122260_() - b.m_122260_(), a.m_122269_() - b.m_122269_());
    }

    private static Vector3f Add(Vector3f a, Vector3f b) {
        return new Vector3f(a.m_122239_() + b.m_122239_(), a.m_122260_() + b.m_122260_(), a.m_122269_() + b.m_122269_());
    }

    private static Vector3f Mul(Vector3f a, float f) {
        return new Vector3f(a.m_122239_() * f, a.m_122260_() * f, a.m_122269_() * f);
    }

    public static void renderHighLightedBlocksOutline(VertexConsumer buffer, Matrix4f positionMatrix, float mx, float my, float mz, float r, float g, float b, float a) {
        buffer.m_85982_(positionMatrix, mx, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx + 1.0f, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, mx, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public static void fill(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int color, int lightmap) {
        int swapper;
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        if (x1 < x2) {
            swapper = x1;
            x1 = x2;
            x2 = swapper;
        }
        if (y1 < y2) {
            swapper = y1;
            y1 = y2;
            y2 = swapper;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
        builder.m_85982_(positionMatrix, (float)x1, (float)y2, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y2, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y1, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x1, (float)y1, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
    }
}

